using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;


namespace delta_of_build
{
	
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button m_SelectPath;
		private System.Windows.Forms.TextBox m_Output;
		private System.Windows.Forms.FolderBrowserDialog m_SelectFolderDialog;
		private System.Windows.Forms.Button m_start;
		public string Path;
		private System.Windows.Forms.RadioButton m_changes;
		private System.Windows.Forms.RadioButton m_full;
		public string FileDirectory = Directory.GetCurrentDirectory()+"\\System";
		public string Line = null;
		public int HighestBuildNumber=0;
		public int i=0;
		public string[] BuildNumbers = new string[1000];
		public int compare=0;
		
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.m_SelectPath = new System.Windows.Forms.Button();
			this.m_Output = new System.Windows.Forms.TextBox();
			this.m_SelectFolderDialog = new System.Windows.Forms.FolderBrowserDialog();
			this.m_start = new System.Windows.Forms.Button();
			this.m_changes = new System.Windows.Forms.RadioButton();
			this.m_full = new System.Windows.Forms.RadioButton();
			this.SuspendLayout();
			// 
			// m_SelectPath
			// 
			this.m_SelectPath.Location = new System.Drawing.Point(24, 64);
			this.m_SelectPath.Name = "m_SelectPath";
			this.m_SelectPath.Size = new System.Drawing.Size(104, 32);
			this.m_SelectPath.TabIndex = 0;
			this.m_SelectPath.Text = "Select destination folder";
			this.m_SelectPath.Click += new System.EventHandler(this.m_SelectPath_Click);
			// 
			// m_Output
			// 
			this.m_Output.BackColor = System.Drawing.Color.White;
			this.m_Output.Location = new System.Drawing.Point(16, 16);
			this.m_Output.Name = "m_Output";
			this.m_Output.ReadOnly = true;
			this.m_Output.Size = new System.Drawing.Size(424, 20);
			this.m_Output.TabIndex = 1;
			this.m_Output.Text = "";
			// 
			// m_SelectFolderDialog
			// 
			this.m_SelectFolderDialog.ShowNewFolderButton = false;
			// 
			// m_start
			// 
			this.m_start.Font = new System.Drawing.Font("Monotype Corsiva", 24F, System.Drawing.FontStyle.Italic, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.m_start.Location = new System.Drawing.Point(288, 56);
			this.m_start.Name = "m_start";
			this.m_start.Size = new System.Drawing.Size(136, 48);
			this.m_start.TabIndex = 2;
			this.m_start.Text = "Start";
			this.m_start.Click += new System.EventHandler(this.m_start_Click);
			// 
			// m_changes
			// 
			this.m_changes.Checked = true;
			this.m_changes.Location = new System.Drawing.Point(152, 56);
			this.m_changes.Name = "m_changes";
			this.m_changes.Size = new System.Drawing.Size(120, 24);
			this.m_changes.TabIndex = 3;
			this.m_changes.TabStop = true;
			this.m_changes.Text = "Get changes Only";
			this.m_changes.CheckedChanged += new System.EventHandler(this.radioButton1_CheckedChanged);
			// 
			// m_full
			// 
			this.m_full.Location = new System.Drawing.Point(152, 88);
			this.m_full.Name = "m_full";
			this.m_full.TabIndex = 4;
			this.m_full.Text = "Get full build";
			this.m_full.CheckedChanged += new System.EventHandler(this.radioButton2_CheckedChanged);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Control;
			this.ClientSize = new System.Drawing.Size(458, 120);
			this.Controls.Add(this.m_full);
			this.Controls.Add(this.m_changes);
			this.Controls.Add(this.m_start);
			this.Controls.Add(this.m_Output);
			this.Controls.Add(this.m_SelectPath);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "Form1";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "DeltaBuild";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		static void Main() 
		{
			Application.Run(new Form1());
		}


		private void Form1_Load(object sender, System.EventArgs e)
		{
		
		}

		// Function for reading a line from a file
		public static string ReadLineFromFile(StreamReader SR)
		{
			string Input = null;
			Input = SR.ReadLine();
			return (Input);
		}	
		
		private void m_SelectFolderDialog_HelpRequest(object sender, System.EventArgs e)
		{
		
		}

		// Function to execute a javascript which is getting the different Buildnames and writing them to a file
		public void GetAlienbrainBuildNames()
		{
			string cmdLine = "\""+FileDirectory + "\\get_names.wsf\"";
			System.Diagnostics.Process Process;
			Process = new System.Diagnostics.Process();
			Process = System.Diagnostics.Process.Start("wscript", cmdLine);
			Process.WaitForExit();
		}
			
		

		private void m_SelectPath_Click(object sender, System.EventArgs e)
		{
			// Brings up a Select folder dialog and is showing up the result in a textbox
			FolderBrowserDialog MyDialog = new FolderBrowserDialog();
			DialogResult Result= MyDialog.ShowDialog();
			Path=MyDialog.SelectedPath;
			if(Result == DialogResult.OK)
			{
				m_Output.Clear();
				m_Output.AppendText(Path);	
			}
		}

		private void m_start_Click(object sender, System.EventArgs e)
		{	
			if(m_Output.Text!="")
			{
				GetAlienbrainBuildNames();
				if(!File.Exists(FileDirectory+"\\builds.txt"))
				{
					MessageBox.Show("No records of Full Builds in Alienbrain.\nPlease check Alienbrain access","Error", MessageBoxButtons.OK , MessageBoxIcon.Error);
				}
				else
				{
					if(m_changes.Checked==true )
					{	
						if(!File.Exists(FileDirectory+"\\Last_Full_Get.txt"))
						{
							MessageBox.Show("No record of last get of an Full Build.\nPlease get first the latest Full Build","Error", MessageBoxButtons.OK , MessageBoxIcon.Error);
						}
						else
						{
							if(MessageBox.Show("This Operation will overwrite your local Files.\n    Please backup/checkin all your Work!\n              Continue with get latest? ","Attention", MessageBoxButtons.YesNo, MessageBoxIcon.Warning)==DialogResult.Yes)
							{
							
								StreamReader builds = File.OpenText(FileDirectory+"\\builds.txt");
								do
								{
									Line = ReadLineFromFile(builds);
									if(Line== null)
									{
										break;
									}
									BuildNumbers[i]=Line.Substring(Line.IndexOf("(",0,17)+1,4);
									i++;
								}while(Line != null);
								builds.Close();
					
								i=0;
								do
								{
									compare=int.Parse(BuildNumbers[i]);
									i++;
									if(HighestBuildNumber<compare)
									{
										HighestBuildNumber=compare;
									}
									else if(BuildNumbers[i]==null)
									{
										break;
									}												
								}while(compare!=0);

							
		
								StreamReader LastGet = File.OpenText(FileDirectory+"\\Last_Full_Get.txt");
								Line = ReadLineFromFile(LastGet);
								LastGet.Close();
								string LastFullGet=Line.Substring(Line.IndexOf("(",0,17)+1,4);

								compare=int.Parse(LastFullGet);
								if(compare<HighestBuildNumber)
								{
									MessageBox.Show("First you need to get the latest Full Build");
								}
								else
								{
									Path="\""+Path+"\"";
									// Execution command-line
									string cmdLine;
									cmdLine = "\""+FileDirectory;
									cmdLine += "\\sync.wsf\"";
									cmdLine += " /LocalPath:"+Path+" /SyncType:Delta";
									System.Diagnostics.Process Process;
									Process = new System.Diagnostics.Process();
									Process = System.Diagnostics.Process.Start("wscript", cmdLine);
									Process.WaitForExit();
									if(Process.ExitCode!=0)
									{
										Application.Exit();
									}
								}
							}
						}
					}
					else if(m_full.Checked==true )
					{
						Form2 newdialog = new Form2();
						newdialog.writetoform2(Path);
						newdialog.ShowDialog();
					}

		
			
					/*else
					{
						Application.Exit();
						Application.ExitThread();
					}*/
				}
			}
			else
			{
				MessageBox.Show("Please choose a Folder","Error", MessageBoxButtons.OK , MessageBoxIcon.Error);
			}
		}

		private void radioButton1_CheckedChanged(object sender, System.EventArgs e)
		{
		
		}

		private void radioButton2_CheckedChanged(object sender, System.EventArgs e)
		{
		
		}

		private void dataView1_ListChanged(object sender, System.ComponentModel.ListChangedEventArgs e)
		{
		
		}
	}
}
